/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
// Then modified to generalise to any number of sides .

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// by Nikos Papadopoulos, 4rknova / 2015
// WTFPL

#define N    2                          // Number of sides
#define T    iGlobalTime                // Time
#define S(x)  // Texture

const float  E = 0.02;                  // Edge width
const vec2   A = vec2(0.33,1.5);        // Size XY
float PN = radians(360.0/float(N));

float cT = cos(T);

void mainImage ( out vec4 c, vec2 p )
{
    vec2 u = p.xy / iResolution.xy*2.0 - 1.0;

    float v[N];

    for ( int i = 0; i < N; ++i )
     { v[i] = A.x * sin ( A.y*sin(u.y*cT) + cT + PN*i );
     }

    for ( int i = 0; i < N; ++i )
     {
       int j = int ( mod ( float(i+1), float(N)) );

       float n = v[j];
       float p = v[i];

       if ( n > p && u.x < n && u.x > p )
        {
          float k = n - p;
          float x = (u.x-p) / k;        
     
          float e = A.x * E;

          e = smoothstep ( 0.0, e,   x   )
            * smoothstep ( 0.0, e, 1.0-x );

          e = pow(e,3.0);

          c = texture2D ( iChannel0, A*vec2(x,1.0-u.y) )
            * vec4(e,e,e,1.0);

          return;

        }

     }

    // Not one of the faces of the object, return c as transparent.

    c = vec4(0.0);

}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}